<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TransactionComment extends Model
{
    protected $fillable = [
        'transaction_id',
        'user_id',
        'user_first_name',
        'user_role',
        'comment',
    ];

    public function transaction()
    {
        return $this->belongsTo(Transaction::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}

